/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.handlers;

import com.aptana.core.resources.RequestCancelledException;
import com.aptana.core.resources.SocketMessagesHandler;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.dialogs.InputMessageDialog;
import com.aptana.ui.dialogs.MultipleInputMessageDialog;
import com.aptana.ui.handlers.Messages;
import com.aptana.ui.util.UIUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class AppcSocketMessagesHandler
extends SocketMessagesHandler {
    private static final String MESSAGE = "message";
    private static final String ERROR = "error";
    private static final String QUESTION = "question";
    private static final String TYPE = "type";
    private final String actionName;
    private String description;

    public AppcSocketMessagesHandler() {
        this(Messages.AppcSocketMessagesHandler_title, Messages.AppcSocketMessagesHandler_Description);
    }

    public AppcSocketMessagesHandler(String actionName, String description) {
        this.actionName = actionName;
        this.description = description;
    }

    public JsonNode handleRequest(JsonNode request) throws RequestCancelledException {
        JsonNode type = request.path(TYPE);
        if (QUESTION.equals(type.asText())) {
            return this.handleQuestion(request);
        }
        if (ERROR.equals(type.asText())) {
            System.err.println(request.path(MESSAGE).asText());
            if (request.has(QUESTION)) {
                return this.handleQuestion(request);
            }
        }
        return null;
    }

    private JsonNode handleQuestion(JsonNode type) throws RequestCancelledException {
        final JsonNode questionNode = type.path(QUESTION);
        final ObjectNode[] response = new ObjectNode[1];
        JsonNode qType = type.path(TYPE);
        String asText = type.path(MESSAGE).asText();
        this.description = ERROR.equals(qType.asText()) && !StringUtil.isEmpty((String)asText) ? asText : Messages.AppcSocketMessagesHandler_Description;
        UIUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                InputMessageDialog dialog = questionNode.isArray() ? new MultipleInputMessageDialog(questionNode, AppcSocketMessagesHandler.this.actionName, AppcSocketMessagesHandler.this.description) : new InputMessageDialog(questionNode, AppcSocketMessagesHandler.this.actionName, AppcSocketMessagesHandler.this.description);
                int exitCode = dialog.open();
                response[0] = exitCode == 0 ? (ObjectNode)dialog.getValue() : null;
            }
        });
        if (response[0] == null && this.isWorkbenchLaunched()) {
            throw new RequestCancelledException();
        }
        return response[0];
    }

    private boolean isWorkbenchLaunched() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getWorkbenchWindowCount() == 0;
        }
        return false;
    }
}

